<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateLeadActivitiesTable extends Migration
{
    public function up()
    {
        Schema::create('lead_activities', function (Blueprint $table) {
            $table->id();

            $table->unsignedBigInteger('lead_id');
            $table->enum('activity_type', ['call', 'email', 'meeting', 'note', 'whatsapp']);
            $table->text('description')->nullable();
            $table->timestamp('next_follow_up_at')->nullable();
            $table->timestamp('followed_up_at')->nullable();

            $table->unsignedBigInteger('created_by')->nullable(); // the user who added the activity

            $table->timestamps();
            $table->softDeletes();

            // Foreign key constraints
            $table->foreign('lead_id')->references('id')->on('leads')->onDelete('cascade');
            $table->foreign('created_by')->references('id')->on('users')->onDelete('set null');
        });
    }

    public function down()
    {
        Schema::dropIfExists('lead_activities');
    }
}
